/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatter;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateFormatter
implements PmDataFormatter {
    protected static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters.res.formatter";
    private static final String TRACE_MASKD = "XFMTDATD";
    private static final String TRACE_MASKF = "XFMTDATF";
    private static final String TRACE_MASKT = "XFMTDATT";

    public String format(Object rawObject) {
        Trace.trace(TRACE_MASKT, "-> DateFormatter.format(" + rawObject + ")");
        if (rawObject instanceof Calendar) {
            Date date = ((Calendar)rawObject).getTime();
            DateFormat format = DateFormat.getDateInstance();
            return format.format(date);
        }
        Trace.trace(TRACE_MASKF, "DateFormatter.format() - rawObject was not a Calendar!");
        return "";
    }

    public Object parse(Object source) throws ValidationException {
        Trace.trace(TRACE_MASKT, "-> DateFormatter.parse(" + source + ")");
        if (source instanceof String) {
            try {
                DateFormat format = DateFormat.getDateInstance();
                Date date = format.parse((String)source);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException pe) {
                Trace.trace(TRACE_MASKF, "DateFormatter.parse() - Exception during parse!: " + pe.getMessage());
                throw new ValidationException(new MessageText(RESOURCE_BUNDLE, "DateFailedToParse", new Object[]{source}));
            }
        }
        Trace.trace(TRACE_MASKF, "DateFormatter.parse() - source was not a String!");
        return null;
    }
}

